/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.QuotingDMLNameProvider;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.UpdateCommandBuilder;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class UpdateCommandBuilderTest {
    UpdateCommandBuilderTest() {
    }

    @Test
    <T extends Table<T>> void toSQL_singleTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Update update = new Update(totoTable, (Where)QueryEase.where((Selectable)columnA, (ConditionalOperator)Operators.eq((Object)44)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB)));
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set  where a = 44 or a = b");
        update = new Update(totoTable).set(columnA, columnB);
        testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = b");
        update = new Update(totoTable).set(columnA, (Object)"tata");
        testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = 'tata'");
    }

    @Test
    <T extends Table<T>> void toSQL_keywordsAreEscaped() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Update update = new Update(totoTable).set(columnB, (Object)"tata");
        DefaultDialect dialect = new DefaultDialect(){

            @Override
            protected DMLNameProviderFactory newDMLNameProviderFactory() {
                return QuotingDMLNameProvider::new;
            }
        };
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update `Toto` set `b` = 'tata'");
    }

    @Test
    <T1 extends Table<T1>, T2 extends Table<T2>> void toSQL_multiTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Table tataTable = new Table("Tata");
        Column columnX = tataTable.addColumn("x", Long.class);
        Column columnY = tataTable.addColumn("y", String.class);
        Column columnZ = tataTable.addColumn("z", String.class);
        Update update1 = new Update(totoTable, (Where)QueryEase.where((Selectable)columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY)));
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update1, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set  where Toto.a = Tata.x or Toto.a = Tata.y");
        Update update2 = new Update(totoTable, (Where)QueryEase.where((Selectable)columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY))).set(columnC, columnZ);
        testInstance = new UpdateCommandBuilder(update2, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set Toto.c = Tata.z where Toto.a = Tata.x or Toto.a = Tata.y");
    }

    @Test
    <T extends Table<T>> void toStatement() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable, (Where)QueryEase.where((Selectable)columnA, (ConditionalOperator)Operators.in((Object[])new Long[]{42L, 43L})).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB))).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666);
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("update Toto set b = a, c = ?, d = ? where a in (?, ?) or a = b");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)1, (Object)"tata").add((Object)2, (Object)666).add((Object)3, (Object)42L).add((Object)4, (Object)43L));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)4)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(1, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setInt(2, 666);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(3, 42L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(4, 43L);
        result.setValue(columnC, (Object)"tutu");
        result.applyValues(preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(1, "tutu");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setInt(2, 666);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setLong(3, 42L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setLong(4, 43L);
    }

    @Test
    <T extends Table<T>> void toStatement_withPlaceHolderInCriteria() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable, QueryEase.where((Selectable)columnC, (ConditionalOperator)Operators.likeArgNamed((String)"criterion", String.class))).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666).set("criterion", (Object)"t");
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("update Toto set b = a, c = ?, d = ? where c like ?");
        Assertions.assertThat((Map)result.getValues()).containsAllEntriesOf((Map)Maps.asMap((Object)1, (Object)"tata").add((Object)2, (Object)666));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(1, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setInt(2, 666);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(3, "t");
        result.setValue(columnC, (Object)"tutu");
        result.applyValues(preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)1))).setString(1, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)1))).setString(1, "tutu");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setInt(2, 666);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock, (VerificationMode)Mockito.times((int)2))).setString(3, "t");
    }

    @Test
    <T extends Table<T>> void toStatement_placeholderValueIsNotSet_throwsException() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable, QueryEase.where((Selectable)columnC, (ConditionalOperator)Operators.likeArgNamed((String)"criterion", String.class))).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666);
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("update Toto set b = a, c = ?, d = ? where c like ?");
        Assertions.assertThat((Map)result.getValues()).containsAllEntriesOf((Map)Maps.asMap((Object)1, (Object)"tata").add((Object)2, (Object)666));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> result.applyValues(preparedStatementMock)).isInstanceOf(IllegalStateException.class)).hasMessage("Statement expect values for placeholders: criterion");
    }

    @Test
    <T extends Table<T>> void toStatement_givenPlaceholderNameDoesntMatchAnyExistingOne_throwsException() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable, QueryEase.where((Selectable)columnC, (ConditionalOperator)Operators.likeArgNamed((String)"criterion", String.class))).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666).set("xxx", (Object)"t");
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)new DefaultDialect());
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> ((UpdateCommandBuilder)testInstance).toStatement()).isInstanceOf(IllegalArgumentException.class)).hasMessage("No placeholder named \"xxx\" found in statement, available are [criterion]");
    }

    @Test
    <T extends Table<T>> void toStatement_columnParameterBinderIsOverridden_columnParameterBinderIsUsed() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666);
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        dialect.getColumnBinderRegistry().register(columnD, DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER);
        result.setValue(columnD, (Object)-666);
        result.applyValues(preparedStatementMock);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setInt(2, -666);
    }
}

